package it.unicam.pizzeria4.servizio;

import it.unicam.pizzeria4.util.Course;

public class Bevanda extends Ordinazione {

	private int quantita;
	private String note;
	private int ordine;
	private Bibita bibita;
	
	public Bevanda(Bibita bibita, int quantita) {
		super();
		this.quantita = quantita;
		this.bibita = bibita;
	}
	
	public int getQuantita() {
		return quantita;
	}
	
	public void setQuantita(int quantita) {
		this.quantita = quantita;
	}
	
	public String getNote() {
		return note;
	}
	
	public void setNote(String note) {
		this.note = note;
	}
	
	public int getOrdine() {
		return ordine;
	}
	
	public void setOrdine(int ordine) {
		this.ordine = ordine;
	}
	
	public Bibita getBibita() {
		return bibita;
	}
	
	public void setBibita(Bibita bibita) {
		this.bibita = bibita;
	}
	
	@Override
	public String getID() {
		return bibita.getID();
	}
	
	@Override
	public String getNome() {
		return bibita.getNome();
	}
	
	@Override
	public Course getTipo() {
		return (bibita.isAlcolica() ? Course.bibitaAlcolica : Course.bibitaAnalcolica);
	}
	
	@Override
	public double getPrezzo() {
		return bibita.getPrezzo();
	}

	@Override
	public String getIngredienti() {
		return bibita.getDescrizione();
	}
	
	@Override
	public String getIntolleranze() {
		return bibita.getIntolleranze();
	}
}
